
#include "../game/q_shared.h"
#include "../qcommon/qcommon.h"
#include "win_local.h"

// install the internet SDK from
// http://www.microsoft.com/msdownload/platformsdk/sdkupdate/
// in VC6 you will also need to add the include path and lib path in Tools > Options > Directories
#include <iptypes.h>
#include <iphlpapi.h>


//7Killer Start
 SOCKET ip_socket_F;
 SOCKET socks_socket_F;
 SOCKET ipx_socket_F;
//7killer End
static char socksBuf_F[4096];
static struct sockaddr socksRelayAddr_F;
cvar_t   *net_socksPort_F;


//7Killer Start
void Sys_SendPacket_Facade( int length, const void *data, netadr_t to ) {
	int ret;
	struct sockaddr addr;
	SOCKET net_socket;

	if ( to.type == NA_BROADCAST ) {
		net_socket = ip_socket_F;
	} else if ( to.type == NA_IP )    {
		net_socket = ip_socket_F;
	} else if ( to.type == NA_IPX )    {
		net_socket = ipx_socket_F;
	} else if ( to.type == NA_BROADCAST_IPX )    {
		net_socket = ipx_socket_F;
	} else {
		Com_Error( ERR_FATAL, "Sys_SendPacket: bad address type" );
		return;
	}

	if ( !net_socket ) {
		return;
	}

	NetadrToSockadr( &to, &addr );

	if ( usingSocks && to.type == NA_IP ) {
		socksBuf_F[0] = 0;    // reserved
		socksBuf_F[1] = 0;
		socksBuf_F[2] = 0;    // fragment (not fragmented)
		socksBuf_F[3] = 1;    // address type: IPV4
		*(int *)&socksBuf_F[4] = ( (struct sockaddr_in *)&addr )->sin_addr.s_addr;
		*(short *)&socksBuf_F[8] = ( (struct sockaddr_in *)&addr )->sin_port;
		memcpy( &socksBuf_F[10], data, length );
		ret = sendto( net_socket, socksBuf_F, length + 10, 0, &socksRelayAddr_F, sizeof( socksRelayAddr_F ) );
	} else {
		ret = sendto( net_socket, data, length, 0, &addr, sizeof( addr ) );
	}
	if ( ret == SOCKET_ERROR ) {
		int err = WSAGetLastError();

		// wouldblock is silent
		if ( err == WSAEWOULDBLOCK ) {
			return;
		}

		// some PPP links do not allow broadcasts and return an error
		if ( ( err == WSAEADDRNOTAVAIL ) && ( ( to.type == NA_BROADCAST ) || ( to.type == NA_BROADCAST_IPX ) ) ) {
			return;
		}

		Com_Printf( "NET_SendPacket_Facade: %s\n", NET_ErrorString() );
	}
}
//7Killer End
//7Killer Start

/*
====================
NET_OpenSocks
====================
*/
void NET_OpenSocks_Facade( int port ) {
	struct sockaddr_in address;
	int err;
	struct hostent      *h;
	int len;
	qboolean rfc1929;
	unsigned char buf[64];

	usingSocks = qfalse;

	Com_Printf( "Opening connection to SOCKS server.\n" );

	if ( ( socks_socket_F = socket( AF_INET, SOCK_STREAM, IPPROTO_TCP ) ) == INVALID_SOCKET ) {
		err = WSAGetLastError();
		Com_Printf( "WARNING: NET_OpenSocks: socket: %s\n", NET_ErrorString() );
		return;
	}

	h = gethostbyname( net_socksServer->string );
	if ( h == NULL ) {
		err = WSAGetLastError();
		Com_Printf( "WARNING: NET_OpenSocks: gethostbyname: %s\n", NET_ErrorString() );
		return;
	}
	if ( h->h_addrtype != AF_INET ) {
		Com_Printf( "WARNING: NET_OpenSocks: gethostbyname: address type was not AF_INET\n" );
		return;
	}
	address.sin_family = AF_INET;
	address.sin_addr.s_addr = *(int *)h->h_addr_list[0];
	address.sin_port = htons( (short)net_socksPort_F->integer );

	if ( connect( socks_socket_F, (struct sockaddr *)&address, sizeof( address ) ) == SOCKET_ERROR ) {
		err = WSAGetLastError();
		Com_Printf( "NET_OpenSocks: connect: %s\n", NET_ErrorString() );
		return;
	}

	// send socks authentication handshake
	if ( *net_socksUsername->string || *net_socksPassword->string ) {
		rfc1929 = qtrue;
	} else {
		rfc1929 = qfalse;
	}

	buf[0] = 5;     // SOCKS version
	// method count
	if ( rfc1929 ) {
		buf[1] = 2;
		len = 4;
	} else {
		buf[1] = 1;
		len = 3;
	}
	buf[2] = 0;     // method #1 - method id #00: no authentication
	if ( rfc1929 ) {
		buf[2] = 2;     // method #2 - method id #02: username/password
	}
	if ( send( socks_socket_F, buf, len, 0 ) == SOCKET_ERROR ) {
		err = WSAGetLastError();
		Com_Printf( "NET_OpenSocks: send: %s\n", NET_ErrorString() );
		return;
	}

	// get the response
	len = recv( socks_socket_F, buf, 64, 0 );
	if ( len == SOCKET_ERROR ) {
		err = WSAGetLastError();
		Com_Printf( "NET_OpenSocks: recv: %s\n", NET_ErrorString() );
		return;
	}
	if ( len != 2 || buf[0] != 5 ) {
		Com_Printf( "NET_OpenSocks: bad response\n" );
		return;
	}
	switch ( buf[1] ) {
	case 0: // no authentication
		break;
	case 2: // username/password authentication
		break;
	default:
		Com_Printf( "NET_OpenSocks: request denied\n" );
		return;
	}

	// do username/password authentication if needed
	if ( buf[1] == 2 ) {
		int ulen;
		int plen;

		// build the request
		ulen = strlen( net_socksUsername->string );
		plen = strlen( net_socksPassword->string );

		buf[0] = 1;     // username/password authentication version
		buf[1] = ulen;
		if ( ulen ) {
			memcpy( &buf[2], net_socksUsername->string, ulen );
		}
		buf[2 + ulen] = plen;
		if ( plen ) {
			memcpy( &buf[3 + ulen], net_socksPassword->string, plen );
		}

		// send it
		if ( send( socks_socket_F, buf, 3 + ulen + plen, 0 ) == SOCKET_ERROR ) {
			err = WSAGetLastError();
			Com_Printf( "NET_OpenSocks: send: %s\n", NET_ErrorString() );
			return;
		}

		// get the response
		len = recv( socks_socket_F, buf, 64, 0 );
		if ( len == SOCKET_ERROR ) {
			err = WSAGetLastError();
			Com_Printf( "NET_OpenSocks: recv: %s\n", NET_ErrorString() );
			return;
		}
		if ( len != 2 || buf[0] != 1 ) {
			Com_Printf( "NET_OpenSocks: bad response\n" );
			return;
		}
		if ( buf[1] != 0 ) {
			Com_Printf( "NET_OpenSocks: authentication failed\n" );
			return;
		}
	}

	// send the UDP associate request
	buf[0] = 5;     // SOCKS version
	buf[1] = 3;     // command: UDP associate
	buf[2] = 0;     // reserved
	buf[3] = 1;     // address type: IPV4
	*(int *)&buf[4] = INADDR_ANY;
	*(short *)&buf[8] = htons( (short)port );       // port
	if ( send( socks_socket_F, buf, 10, 0 ) == SOCKET_ERROR ) {
		err = WSAGetLastError();
		Com_Printf( "NET_OpenSocks: send: %s\n", NET_ErrorString() );
		return;
	}

	// get the response
	len = recv( socks_socket_F, buf, 64, 0 );
	if ( len == SOCKET_ERROR ) {
		err = WSAGetLastError();
		Com_Printf( "NET_OpenSocks: recv: %s\n", NET_ErrorString() );
		return;
	}
	if ( len < 2 || buf[0] != 5 ) {
		Com_Printf( "NET_OpenSocks: bad response\n" );
		return;
	}
	// check completion code
	if ( buf[1] != 0 ) {
		Com_Printf( "NET_OpenSocks: request denied: %i\n", buf[1] );
		return;
	}
	if ( buf[3] != 1 ) {
		Com_Printf( "NET_OpenSocks: relay address is not IPV4: %i\n", buf[3] );
		return;
	}
	( (struct sockaddr_in *)&socksRelayAddr_F )->sin_family = AF_INET;
	( (struct sockaddr_in *)&socksRelayAddr_F )->sin_addr.s_addr = *(int *)&buf[4];
	( (struct sockaddr_in *)&socksRelayAddr_F )->sin_port = *(short *)&buf[8];
	memset( ( (struct sockaddr_in *)&socksRelayAddr_F )->sin_zero, 0, 8 );

	usingSocks = qtrue;
}

//7Killer End
/*
====================
NET_OpenIP_F
====================
*/
void NET_OpenIP_Facade( void ) {
	cvar_t  *ip;
	int port;
	int port2;		//7Killer
	int i;

	ip = Cvar_Get( "net_ip", "localhost", CVAR_LATCH );
	port = Cvar_Get( "net_port", va( "%i", PORT_SERVER ), CVAR_LATCH )->integer;
	port2 = Cvar_Get( "net_port2", va( "%i", PORT_SERVER ), CVAR_LATCH )->integer;
	port2 += 1;
	Cvar_SetValue( "net_port2", port2);
				
//need to add cvars to control facade usage
	if(port != port2) {
		ip_socket_F = NET_IPSocket( ip->string, port2);	
		if ( ip_socket_F ) {
			if ( net_socksEnabled->integer ) {
				NET_OpenSocks_Facade( port2);
			}
		} else {
			Com_Printf( "WARNING: Couldn't allocate IP port for facade\n" );

		}
	} else {
//Scan for another port
		for ( i = 0 ; i < 10 ; i++ ) {
			ip_socket_F = NET_IPSocket( ip->string, port2 + i );
			if ( ip_socket_F ) {
				Cvar_SetValue( "net_port2", port2 + i );
				if ( net_socksEnabled->integer ) {
					NET_OpenSocks_Facade( port2 + i );
				}
				return;
			}
		}
		Com_Printf( "WARNING: Couldn't allocate IP port for facade IP Port in the same for main server and facade\n" );
	}
}
/*
====================
NET_OpenIPX_F
====================
*/
void NET_OpenIPX_Facade( void ) {
	int port;
	port = Cvar_Get( "net_port2", va( "%i", PORT_SERVER ), CVAR_LATCH )->integer;
	ipx_socket_F = NET_IPXSocket( port );
}


/*
==================
Sys_GetPacket

Never called by the game logic, just the system event queing
==================
*/
int recvfromCount_F;

qboolean Sys_GetPacket_Facade( netadr_t *net_from, msg_t *net_message ) {
	int ret;
	struct sockaddr from;
	int fromlen;
	int net_socket;
	int protocol;
	int err;

	for ( protocol = 0 ; protocol < 2 ; protocol++ ) {
		if ( protocol == 0 ) {
			net_socket = ip_socket_F;
		} else {
			net_socket = ipx_socket_F;
		}

		if ( !net_socket ) {
			continue;
		}

		fromlen = sizeof( from );
		recvfromCount_F++;        // performance check
		ret = recvfrom( net_socket, net_message->data, net_message->maxsize, 0, (struct sockaddr *)&from, &fromlen );
		if ( ret == SOCKET_ERROR ) {
			err = WSAGetLastError();

			if ( err == WSAEWOULDBLOCK || err == WSAECONNRESET ) {
				continue;
			}
			Com_Printf( "NET_GetPacket: %s\n", NET_ErrorString() );
			continue;
		}

		if ( net_socket == ip_socket_F ) {
			memset( ( (struct sockaddr_in *)&from )->sin_zero, 0, 8 );
		}

		if ( usingSocks && net_socket == ip_socket_F && memcmp( &from, &socksRelayAddr_F, fromlen ) == 0 ) {
			if ( ret < 10 || net_message->data[0] != 0 || net_message->data[1] != 0 || net_message->data[2] != 0 || net_message->data[3] != 1 ) {
				continue;
			}
			net_from->type = NA_IP;
			net_from->ip[0] = net_message->data[4];
			net_from->ip[1] = net_message->data[5];
			net_from->ip[2] = net_message->data[6];
			net_from->ip[3] = net_message->data[7];
			net_from->port = *(short *)&net_message->data[8];
			net_message->readcount = 10;
		} else {
			SockadrToNetadr( &from, net_from );
			net_message->readcount = 0;
		}

		if ( ret == net_message->maxsize ) {
			Com_Printf( "Oversize packet from %s\n", NET_AdrToString( *net_from ) );
			continue;
		}

		net_message->cursize = ret;
		return qtrue;
	}

	return qfalse;
}
