

#include "../game/q_shared.h"
#include "qcommon.h"


// max size of a network packet
#define MAX_PACKETLEN           1400

typedef struct delaybuf delaybuf_t;
struct delaybuf {
	netsrc_t sock;
	int length;
	char data[MAX_PACKETLEN];
	netadr_t to;
	int time;
	delaybuf_t *next;
};

//bani
extern cvar_t *sv_maxclients;
extern cvar_t *sv_packetloss;
extern cvar_t *sv_packetdelay;
#ifndef DEDICATED
extern cvar_t *cl_packetloss;
extern cvar_t *cl_packetdelay;
#endif
extern cvar_t      *showpackets;

static delaybuf_t *sv_delaybuf_head_F = NULL;
static delaybuf_t *sv_delaybuf_tail_F = NULL;


//7Killer Start
void NET_SendPacket_Facade( netsrc_t sock, int length, const void *data, netadr_t to ) {
//bani
	int packetloss, packetdelay;
	delaybuf_t **delaybuf_head, **delaybuf_tail;

	switch ( sock ) {
#ifndef DEDICATED
	case NS_CLIENT: 
		packetloss = cl_packetloss->integer;
		packetdelay = cl_packetdelay->integer;
		delaybuf_head = &cl_delaybuf_head;
		delaybuf_tail = &cl_delaybuf_tail;
		break;
#endif
	case NS_SERVER:
		packetloss = sv_packetloss->integer;
		packetdelay = sv_packetdelay->integer;
		delaybuf_head = &sv_delaybuf_head_F;
		delaybuf_tail = &sv_delaybuf_tail_F;
		break;

	default:
		// shut up compiler for dedicated
		packetloss = 0;
		packetdelay = 0;
		delaybuf_head = NULL;
		delaybuf_tail = NULL;
		break;
	}

	if ( packetloss > 0 ) {
		if ( ( (float)rand() / RAND_MAX ) * 100 <= packetloss ) {
			if ( showpackets->integer ) {
				Com_Printf( "drop packet %4i\n", length );
			}
			return;
		}
	}

//bani 
	if ( packetdelay ) {
		int curtime;
		delaybuf_t *buf, *nextbuf;

		curtime = Sys_Milliseconds();

		//send any scheduled packets, starting from oldest
		for ( buf = *delaybuf_head; buf; buf = nextbuf ) {

			if ( ( buf->time + packetdelay ) > curtime ) {
				break;
			}

			if ( showpackets->integer ) {
				Com_Printf( "delayed packet(%dms) %4i\n", buf->time - curtime, buf->length );
			}

			switch ( buf->to.type ) {
			case NA_BOT:
			case NA_BAD:
				break;
			case NA_LOOPBACK:
				NET_SendLoopPacket( buf->sock, buf->length, buf->data, buf->to );
				break;
			default:
				Sys_SendPacket_Facade( buf->length, buf->data, buf->to );
				break;
			}

			// remove from queue
			nextbuf = buf->next;
			*delaybuf_head = nextbuf;
			if ( !*delaybuf_head ) {
				*delaybuf_tail = NULL;
			}
			Z_Free( buf );
		}

		// create buffer and add it to the queue
		buf = (delaybuf_t *)Z_Malloc( sizeof( *buf ) );
		if ( !buf ) {
			Com_Error( ERR_FATAL, "Couldn't allocate packet delay buffer\n" );
		}

		buf->sock = sock;
		buf->length = length;
		memcpy( buf->data, data, length );
		buf->to = to;
		buf->time = curtime;
		buf->next = NULL;

		if ( *delaybuf_head ) {
			( *delaybuf_tail )->next = buf;
		} else {
			*delaybuf_head = buf;
		}
		*delaybuf_tail = buf;

		return;
	}

	// sequenced packets are shown in netchan, so just show oob
	if ( showpackets->integer && *(int *)data == -1 ) {
		Com_Printf( "send packet %4i\n", length );
	}

	if ( to.type == NA_LOOPBACK ) {
		NET_SendLoopPacket( sock, length, data, to );
		return;
	}
	if ( to.type == NA_BOT ) {
		return;
	}
	if ( to.type == NA_BAD ) {
		return;
	}

	Sys_SendPacket_Facade( length, data, to );
}
/*
===============
NET_OutOfBandPrint

Sends a text message in an out-of-band datagram
================
*/
void QDECL NET_OutOfBandPrint_Facade( netsrc_t sock, netadr_t adr, const char *format, ... ) {
	va_list argptr;
	char string[MAX_MSGLEN];

	// set the header
	string[0] = -1;
	string[1] = -1;
	string[2] = -1;
	string[3] = -1;

	va_start( argptr, format );
	Q_vsnprintf( string + 4, sizeof( string ) - 4, format, argptr );
	va_end( argptr );

	// send the datagram
	NET_SendPacket_Facade( sock, strlen( string ), string, adr );
}
//7Killer End
