
#include "../game/q_shared.h"
#include "qcommon.h"
#include <setjmp.h>

// htons
#ifdef __linux__
#include <netinet/in.h>
// getpid
#include <unistd.h>
#elif __MACOS__
// getpid
#include <unistd.h>
#else
#include <winsock.h>
#endif

#define MAX_NUM_ARGVS   50

#define MIN_DEDICATED_COMHUNKMEGS 1
#define MIN_COMHUNKMEGS 42 // JPW NERVE changed this to 42 for MP, was 56 for team arena and 75 for wolfSP
#define DEF_COMHUNKMEGS "56" // RF, increased this, some maps are exceeding 56mb // JPW NERVE changed this for multiplayer back to 42, 56 for depot/mp_cpdepot, 42 for everything else
#define DEF_COMZONEMEGS "24" // RF, increased this from 16, to account for botlib/AAS

// bk001129 - here we go again: upped from 64
#define MAX_PUSHED_EVENTS               256
// bk001129 - init, also static
static int com_pushedEventsHead_F = 0;
static int com_pushedEventsTail_F = 0;
// bk001129 - static
static sysEvent_t com_pushedEvents_F[MAX_PUSHED_EVENTS];
fileHandle_t com_journalFile_F;               // events are written here
fileHandle_t com_journalDataFile_F;           // config files are written here

extern cvar_t  *com_journal;
extern cvar_t  *com_dropsim; 

/*
=================
Com_InitJournaling
=================
*/
void Com_InitJournaling_Facade( void ) {
//	Com_StartupVariable( "journal_F" );
	//com_journal = Cvar_Get( "journal_F", "0", CVAR_INIT );
	if ( !com_journal->integer ) {
		return;
	}

	if ( com_journal->integer == 1 ) {
		Com_Printf( "Journaling facade events\n" );
		com_journalFile_F = FS_FOpenFileWrite( "journal_F.dat" );
		com_journalDataFile_F = FS_FOpenFileWrite( "journaldata_F.dat" );
	} else if ( com_journal->integer == 2 ) {
		Com_Printf( "Replaying journaled facade events\n" );
		FS_FOpenFileRead( "journal_F.dat", &com_journalFile_F, qtrue );
		FS_FOpenFileRead( "journaldata_F.dat", &com_journalDataFile_F, qtrue );
	}

	if ( !com_journalFile_F || !com_journalDataFile_F ) {
		Cvar_Set( "com_journal", "0" );
		com_journalFile_F = 0;
		com_journalDataFile_F = 0;
		Com_Printf( "Couldn't open journal facade files\n" );
	}
}


/*
=================
Com_GetRealEvent
=================
*/
sysEvent_t  Com_GetRealEvent_Facade( void ) {
	int r;
	sysEvent_t ev;

	// either get an event from the system or the journal file
	if ( com_journal->integer == 2 ) {
		r = FS_Read( &ev, sizeof( ev ), com_journalFile_F );
		if ( r != sizeof( ev ) ) {
			Com_Error( ERR_FATAL, "Error reading from journal facade file" );
		}
		if ( ev.evPtrLength ) {
			ev.evPtr = Z_Malloc( ev.evPtrLength );
			r = FS_Read( ev.evPtr, ev.evPtrLength, com_journalFile_F );
			if ( r != ev.evPtrLength ) {
				Com_Error( ERR_FATAL, "Error reading from journal facade file" );
			}
		}
	} else {
		ev = Sys_GetEvent_Facade();

		// write the journal value out if needed
		if ( com_journal->integer == 1 ) {
			r = FS_Write( &ev, sizeof( ev ), com_journalFile_F );
			if ( r != sizeof( ev ) ) {
				Com_Error( ERR_FATAL, "Error writing to journal facade file" );
			}
			if ( ev.evPtrLength ) {
				r = FS_Write( ev.evPtr, ev.evPtrLength, com_journalFile_F );
				if ( r != ev.evPtrLength ) {
					Com_Error( ERR_FATAL, "Error writing to journal facade file" );
				}
			}
		}
	}

	return ev;
}

/*
=================
Com_InitPushEvent
=================
*/
// bk001129 - added
void Com_InitPushEvent_Facade( void ) {
	// clear the static buffer array
	// this requires SE_NONE to be accepted as a valid but NOP event
	memset( com_pushedEvents_F, 0, sizeof( com_pushedEvents_F ) );
	// reset counters while we are at it
	// beware: GetEvent might still return an SE_NONE from the buffer
	com_pushedEventsHead_F = 0;
	com_pushedEventsTail_F = 0;
}



/*
=================
Com_PushEvent
=================
*/
void Com_PushEvent_Facade( sysEvent_t *event ) {
	sysEvent_t      *ev;
	static int printedWarning = 0; // bk001129 - init, bk001204 - explicit int

	ev = &com_pushedEvents_F[ com_pushedEventsHead_F & ( MAX_PUSHED_EVENTS - 1 ) ];

	if ( com_pushedEventsHead_F - com_pushedEventsTail_F >= MAX_PUSHED_EVENTS ) {

		// don't print the warning constantly, or it can give time for more...
		if ( !printedWarning ) {
			printedWarning = qtrue;
			Com_Printf( "WARNING: Com_PushEvent facade overflow\n" );
		}

		if ( ev->evPtr ) {
			Z_Free( ev->evPtr );
		}
		com_pushedEventsTail_F++;
	} else {
		printedWarning = qfalse;
	}

	*ev = *event;
	com_pushedEventsHead_F++;
}

/*
=================
Com_GetEvent
=================
*/
sysEvent_t  Com_GetEvent_Facade( void ) {
	if ( com_pushedEventsHead_F > com_pushedEventsTail_F ) {
		com_pushedEventsTail_F++;
		return com_pushedEvents_F[ ( com_pushedEventsTail_F - 1 ) & ( MAX_PUSHED_EVENTS - 1 ) ];
	}
	return Com_GetRealEvent_Facade();
}

/*
=================
Com_RunAndTimeServerPacket
=================
*/
void Com_RunAndTimeServerPacket_Facade( netadr_t *evFrom, msg_t *buf ) {
	int t1, t2, msec;

	t1 = 0;

	if ( com_speeds->integer ) {
		t1 = Sys_Milliseconds();
	}

	SV_PacketEvent_Facade( *evFrom, buf );

	if ( com_speeds->integer ) {
		t2 = Sys_Milliseconds();
		msec = t2 - t1;
		if ( com_speeds->integer == 3 ) {
			Com_Printf( "SV_PacketEvent time: %i\n", msec );
		}
	}
}
#ifndef DEDICATED
extern qboolean consoleButtonWasPressed;
#endif
int Com_EventLoop_Facade( void ) {
	sysEvent_t ev;
	netadr_t evFrom;
	byte bufData[MAX_MSGLEN];
	msg_t buf;

	MSG_Init( &buf, bufData, sizeof( bufData ) );

	while ( 1 ) {
		ev = Com_GetEvent_Facade();

		// if no more events are available
		if ( ev.evType == SE_NONE ) {
			// manually send packet events for the loopback channel
			while ( NET_GetLoopPacket( NS_CLIENT, &evFrom, &buf ) ) {
				CL_PacketEvent( evFrom, &buf );
			}

			while ( NET_GetLoopPacket( NS_SERVER, &evFrom, &buf ) ) {
				// if the server just shut down, flush the events
				if ( com_sv_running->integer ) {
					Com_RunAndTimeServerPacket_Facade( &evFrom, &buf );
				}
			}

			return ev.evTime;
		}


		switch ( ev.evType ) {
		default:
			// bk001129 - was ev.evTime
			Com_Error( ERR_FATAL, "Com_EventLoop Facade: bad event type %i", ev.evType );
			break;
		case SE_NONE:
			break;
		case SE_KEY:
			CL_KeyEvent( ev.evValue, ev.evValue2, ev.evTime );
			break;
		case SE_CHAR:
#ifndef DEDICATED
			// fretn
			// we just pressed the console button,
			// so ignore this event
			// this prevents chars appearing at console input
			// when you just opened it
			if ( consoleButtonWasPressed ) {
				consoleButtonWasPressed = qfalse;
				break;
			}
#endif
			CL_CharEvent( ev.evValue );
			break;
		case SE_MOUSE:
			CL_MouseEvent( ev.evValue, ev.evValue2, ev.evTime );
			break;
		case SE_JOYSTICK_AXIS:
			CL_JoystickEvent( ev.evValue, ev.evValue2, ev.evTime );
			break;
		case SE_CONSOLE:
			Cbuf_AddText( (char *)ev.evPtr );
			Cbuf_AddText( "\n" );
			break;
		case SE_PACKET:
			// this cvar allows simulation of connections that
			// drop a lot of packets.  Note that loopback connections
			// don't go through here at all.
			if ( com_dropsim->value > 0 ) {
				static int seed;

				if ( Q_random( &seed ) < com_dropsim->value ) {
					break;      // drop this packet
				}
			}

			evFrom = *(netadr_t *)ev.evPtr;
			buf.cursize = ev.evPtrLength - sizeof( evFrom );

			// we must copy the contents of the message out, because
			// the event buffers are only large enough to hold the
			// exact payload, but channel messages need to be large
			// enough to hold fragment reassembly
			if ( (unsigned)buf.cursize > buf.maxsize ) {
				Com_Printf( "Com_EventLoop: oversize packet\n" );
				continue;
			}
			memcpy( buf.data, ( byte * )( (netadr_t *)ev.evPtr + 1 ), buf.cursize );
			if ( com_sv_running->integer ) {
				Com_RunAndTimeServerPacket_Facade( &evFrom, &buf );
			} else {
				CL_PacketEvent( evFrom, &buf );
			}
			break;
		}

		// free any block data
		if ( ev.evPtr ) {
			Z_Free( ev.evPtr );
		}
	}

	return 0;   // never reached
}

/*
================
Com_Milliseconds

Can be used for profiling, but will be journaled accurately
================
*/
int Com_Milliseconds_Facade( void ) {
	sysEvent_t ev;

	// get events and push them until we get a null event with the current time
	do {

		ev = Com_GetRealEvent_Facade();
		if ( ev.evType != SE_NONE ) {
			Com_PushEvent_Facade( &ev );
		}
	} while ( ev.evType != SE_NONE );

	return ev.evTime;
}
